/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.sa;

import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.schedops.HMCSchedulable;
import com.ibm.hwmca.fw.schedops.OperationTarget;
import com.ibm.hwmca.fw.schedops.Schedulable;
import com.ibm.hwmca.fw.schedops.SchedulableDescriptor;
import com.ibm.hwmca.fw.schedops.SchedulableException;
import com.ibm.hwmca.fw.schedops.ScheduledOperation;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.p.sa.ServiceAgentAttr;
import com.ibm.hwmca.p.sa.ServiceAgentUtils;

public class ESAXmitServiceInfoSchedulable
implements HMCSchedulable,
ServiceAgentAttr {
    private static final String CLASS_NAME = "[ESAXmitServiceInfoSchedulable] ";
    private static final String TRACE_MASKT = "ESA    T";
    private static final String TRACE_MASKF = "ESA    F";
    private static final String TRACE_MASKD = "ESA    D";
    private SchedulableDescriptor descriptor = null;
    public static String currentMessage = "Service Agent Transmit Info";

    public ESAXmitServiceInfoSchedulable() {
        Trace.trace(TRACE_MASKT, "[ESAXmitServiceInfoSchedulable] <> ESAXmitServiceInfoSchedulable()");
    }

    protected ESAXmitServiceInfoSchedulable(PersistentData data) {
        Trace.trace(TRACE_MASKT, "[ESAXmitServiceInfoSchedulable] <> ESAXmitServiceInfoSchedulable( PersistentData )");
    }

    public synchronized SchedulableDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new Descriptor();
        }
        return this.descriptor;
    }

    public Object performScheduledOperation(ScheduledOperation schedop) throws SchedulableException {
        Trace.trace(TRACE_MASKT, "[ESAXmitServiceInfoSchedulable] >> performScheduledOperation()");
        Object command = schedop.getOperationParameters();
        if (command != null) {
            String className = command.getClass().getName();
            if (className != null) {
                Trace.trace(TRACE_MASKF, "[ESAXmitServiceInfoSchedulable] className: " + className);
                if (className.endsWith("ESAbatchXmitSched")) {
                    int rc = ServiceAgentUtils.XmitScheduled("Xmit_Scheduled");
                } else if (className.endsWith("ESAbatchXmitImmed")) {
                    int rc = ServiceAgentUtils.XmitImmediate("Xmit_Immediate");
                } else if (className.endsWith("ESAbatchXmitVPD")) {
                    ServiceAgentAttr.ESAbatchXmitVPD xmitVPD = (ServiceAgentAttr.ESAbatchXmitVPD)command;
                    int rc = ServiceAgentUtils.XmitVPD(xmitVPD.machType, xmitVPD.machModel, xmitVPD.machSerial);
                } else if (className.endsWith("ESAbatchEEDrequest")) {
                    ServiceAgentAttr.ESAbatchEEDrequest eed = (ServiceAgentAttr.ESAbatchEEDrequest)command;
                    int rc = ServiceAgentUtils.ESASendEEDRequest(eed.RequestType, eed.MachType, eed.MachModel, eed.MachSerial, eed.ProblemNumber, eed.Pmh, eed.EEDFilename, eed.ProblemUUID, eed.AltEEDFilename);
                } else if (className.endsWith("ESAbatchXmitPMImmed")) {
                    ServiceAgentAttr.ESAbatchXmitPMImmed xmitPMImmed = (ServiceAgentAttr.ESAbatchXmitPMImmed)command;
                    int rc = ServiceAgentUtils.XmitPM("Xmit_PM_Immediate");
                } else if (className.endsWith("ESAbatchXmitPMSched")) {
                    ServiceAgentAttr.ESAbatchXmitPMSched xmitPMSched = (ServiceAgentAttr.ESAbatchXmitPMSched)command;
                    int rc = ServiceAgentUtils.XmitPM("Xmit_PM_Scheduled");
                } else {
                    Trace.trace(TRACE_MASKF, "[ESAXmitServiceInfoSchedulable] unsupported command object: " + className);
                }
            } else {
                Trace.trace(TRACE_MASKF, "[ESAXmitServiceInfoSchedulable] className was null");
            }
        } else {
            Trace.trace(TRACE_MASKF, "[ESAXmitServiceInfoSchedulable] command object was null");
        }
        Trace.trace(TRACE_MASKT, "[ESAXmitServiceInfoSchedulable] << performScheduledOperation()");
        return null;
    }

    public PersistentData getPersistentData() {
        return new PersistedData();
    }

    public boolean isUpgradeData() {
        return false;
    }

    public static class Descriptor
    implements SchedulableDescriptor {
        public LocalizableText getDescription() {
            return new LocalizableText(currentMessage);
        }

        public Schedulable createSchedulable(OperationTarget target) {
            return new ESAXmitServiceInfoSchedulable();
        }

        public boolean isDisplayableOnUI(OperationTarget target) {
            return false;
        }

        public boolean isSelectableOnUI(OperationTarget target) {
            return false;
        }

        public String getOperationParametersTasklet() {
            return null;
        }
    }

    private static class PersistedData
    implements PersistentData {
        private PersistedData() {
        }
    }
}

